#1. Installer et charger les packages nécessaires à la réalisation de l'exercice
install.packages(c("readr", "tidyverse", "questionr", "esquisse"))
#install.packages : à faire la première fois
#library : à faire à chaque démarrage de R
library(readr) ; library(tidyverse) ; library(questionr) ; library(esquisse) 

#2. Importer les données (via "Import dataset", qui génère et exécute les lignes de code ci-dessous)
ERFI1_FPA <- read_csv("data/ERFI1_FPA.csv")
View(ERFI1_FPA) 

#3. Explorer le jeu de données
str(ERFI1_FPA)
#indique le type d'objet (ici, data.frame = tableau de données), sa taille : 10 079 x 86 = 10079 lignes et 86 colonnes, soit 10079 individus et 86 variables
#puis la liste des variables avec leur type (ici toutes num = numérique) avec les valeurs pour les 10 premières lignes
summary(ERFI1_FPA)
#statistiques descriptives sur toutes les variables de type numérique (mais pas forcément quantitatives : ça n'a pas toujours du sens ! Ex: variable MA_SEXE)

#Reproduire la figure 1 du Pop & Soc
#on crée une nouvelle table avec uniquement les variables dont on aura besoin
erfi <- select(ERFI1_FPA, MA_AGEM_rec, PA_FQAVM_rec, PF_AGEDEPFOY_rec, PA_MEREBV_rec, poids12)

#tri à plat sur les deux variables d'intéret, pour voir les données manquantes
table(erfi$PF_AGEDEPFOY_rec, useNA = "always")

#on filtre la population concernée par le graphique : personnes d'au moins 30 ans et ayant leurs deux parents en vie
erfi <- filter(erfi, MA_AGEM_rec >= 30 & PA_MEREBV_rec == 1)
erfi <- filter(erfi, complete.cases(PF_AGEDEPFOY_rec))

#recoder l'âge au départ du foyer parental : avec l'outil icut de questionr
icut()
## Recodage de erfi$PF_AGEDEPFOY_rec en erfi$AGE_DEP
erfi$AGE_DEP <- cut(erfi$PF_AGEDEPFOY_rec,
  include.lowest = TRUE,
  right = FALSE,
  dig.lab = 4,
  breaks = c(0, 20, 22, 24, 26, 30, 79)
)

#recoder fréquence de visite à la mère (au moins une fois par semaine :  oui/non) avec irec de questionr
irec()

## Recodage de erfi$PA_FQAVM_rec en erfi$FREQ_MERE
erfi$FREQ_MERE <- as.character(erfi$PA_FQAVM_rec)
erfi$FREQ_MERE[erfi$PA_FQAVM_rec == "0"] <- "non"
erfi$FREQ_MERE[erfi$PA_FQAVM_rec == "1"] <- "non"
erfi$FREQ_MERE[erfi$PA_FQAVM_rec == "2"] <- "oui"
erfi$FREQ_MERE[erfi$PA_FQAVM_rec == "3"] <- "oui"
erfi$FREQ_MERE[erfi$PA_FQAVM_rec == "9"] <- "non"

#tris à plat
#1. sur l'âge au départ
wtd.table(erfi$AGE_DEP, weights = erfi$poids12) %>% #tableau d'effectifs
proportions() #calcule les pourcentages

#2. sur la fréquence de visite à la mère
wtd.table(erfi$FREQ_MERE, weights = erfi$poids12) %>%
proportions()

#Tri croisé
wtd.table(erfi$AGE_DEP, erfi$FREQ_MERE, weights = erfi$poids12) %>%
lprop() #lprop calcule des % ligne, cprop des % colonnes


#histogramme 
#1. préparer les données 
#On assigne le tableau obtenu à l'issue du tri croisé dans un objet nommé T
TCROIS <- wtd.table(erfi$AGE_DEP, erfi$FREQ_MERE, weights = erfi$poids12) %>%
  lprop()

class(TCROIS)

erfi_mere <- as.data.frame(TCROIS) %>% #on transforme T en data frame
  rename(age = Var1, visite_mere = Var2) %>% #on renomme certaines colonnes pour que les noms soient plus explicites
  filter(age != "Ensemble" & visite_mere != "Total") #on filtre pour enlever les marges du tableau croisé


#2. réaliser le graphique avec Esquisse
esquisser()


#code généré par Esquisse
ggplot(erfi_mere) +
 aes(x = age, y = Freq, fill = visite_mere) +
 geom_col() +
 scale_fill_manual(values = c(non = "#A50026", 
oui = "#006837")) +
 labs(x = "Age au départ (ans)", y = "En %", title = "Proportion (%) d'enfants voyant au moins une fois par semaine leur mère selon l'âge au départ du foyer parental", 
 caption = "Champ : femmes et hommes âgés de 30 à 79 ans, dont la mère est encore en vie ; Source : Ined-Insee, ERFI-GGS, 2005", 
 fill = "Voit sa mère au moins une fois par semaine") +
 theme_classic() +
 theme(plot.title = element_text(face = "bold.italic", 
 hjust = 0.5), plot.caption = element_text(face = "italic", hjust = 0), axis.title.y = element_text(hjust = 1), 
 axis.title.x = element_text(hjust = 1))


#on peut tout faire avec sjPlot (et sans avoir à calculer les pourcentages en amont du graphique)... mais il faut coder. 
#C'est un package très adapté au traitement de données d'enquête en sciences sociales (mais peu connu, pas de doc en français à ma connaissance)
#Mais je pense qu'il vaut mieux rester sur du basique (= plus simple) pour ce kit.

library(sjPlot)
options(OutDec=",") #pour que le marqueur décimal soit une virgule

#tableau croisé
tab_xtab(var.row = erfi$AGE_DEP, #variable en ligne
         var.col = erfi$FREQ_MERE, #variable en colonne
         weight.by = erfi$poids12, #pondération
         show.summary = FALSE, #ne pas afficher de test statistique
         show.obs = FALSE, #ne pas afficher les effectifs
         show.row.prc = TRUE, #afficher les % en ligne (pour afficher les % en colonne, utiliser show.col.prc  = TRUE)
         title = "Proportion d'enfants voyant au moins une fois par semaine leur mère selon l'âge au départ du foyer parental", #titre du tableau
         var.labels = c("Age au départ du foyer parental", "Voit sa mère au moins une fois par semaine"), #labels pour les noms des variables
         value.labels = list(c("Moins de 20 ans", "20-21", "22-23", "24-25", "26-29", "30 ans ou plus"), #labels pour les modalités
                             c("Non", "Oui")),
         encoding = "UTF-8") #pour que les caractères accentués apparaissent correctement

#graphique (avec sjPlot)
plot_xtab(x = erfi$AGE_DEP,
          grp = erfi$FREQ_MERE,
          weight.by = erfi$poids12,
          margin = "row",
          bar.pos = "stack",
          show.total = FALSE,
          show.n = FALSE,
          title = "Proportion d'enfants voyant au moins une fois par semaine leur mere selon l'age au depart du foyer parental",
          axis.titles = c("Age au depart du foyer parental"),
          axis.labels = c("Moins de 20 ans", "20-21", "22-23", "24-25", "26-29", "30 ans ou plus"),
          legend.title = "voit sa mère au moins une fois par semaine")



#code pour reproduire exactement le graphique du Pop&Soc (à mettre dans un encadré à la fin du kit ?)

#sélection des variables utiles et des individus concernés
erfi <- select(ERFI1_FPA, MA_AGEM_rec, PA_FQAVM_rec, PF_AGEDEPFOY_rec, PA_MEREBV_rec, PB_PEREBV_rec, PB_FQAVP_rec, poids12)
erfi <- filter(erfi, MA_AGEM_rec >= 30 & PA_MEREBV_rec == 1 & PB_PEREBV_rec == 1)
erfi <- filter(erfi, complete.cases(PF_AGEDEPFOY_rec))

#recodage âge au départ du foyer
erfi$AGE_DEP <- cut(erfi$PF_AGEDEPFOY_rec,
                    include.lowest = TRUE,
                    right = FALSE,
                    dig.lab = 4,
                    breaks = c(0, 20, 22, 24, 26, 30, 79)
)

#recodage fréquence des visites aux parents
erfi$FREQ_MERE <- as.character(erfi$PA_FQAVM_rec)
erfi$FREQ_MERE[erfi$PA_FQAVM_rec == "0"] <- "non"
erfi$FREQ_MERE[erfi$PA_FQAVM_rec == "1"] <- "non"
erfi$FREQ_MERE[erfi$PA_FQAVM_rec == "2"] <- "oui"
erfi$FREQ_MERE[erfi$PA_FQAVM_rec == "3"] <- "oui"
erfi$FREQ_MERE[erfi$PA_FQAVM_rec == "9"] <- "non"

erfi$FREQ_PERE <- as.character(erfi$PB_FQAVP_rec)
erfi$FREQ_PERE[erfi$PB_FQAVP_rec == "0"] <- "non"
erfi$FREQ_PERE[erfi$PB_FQAVP_rec == "1"] <- "non"
erfi$FREQ_PERE[erfi$PB_FQAVP_rec == "2"] <- "oui"
erfi$FREQ_PERE[erfi$PB_FQAVP_rec == "3"] <- "oui"
erfi$FREQ_PERE[erfi$PB_FQAVP_rec == "9"] <- "non"

#calcul des % pour les visites à la mère
TAB_MERE <- wtd.table(erfi$AGE_DEP, erfi$FREQ_MERE, weights = erfi$poids12) %>%
  lprop() %>% as.data.frame() %>%
  rename(age = Var1, visite = Var2) %>%
  filter(age != "Ensemble" & visite == "oui") %>% #on veut représenter sur le graphique seulement la part de personnes qui voient leur mère une fois par semaine, donc on ne garde que les "oui"
  mutate(parent = "mere") #on crée une nouvelle variable indiquant le parent concerné

#on fait de même pour les visites au père
TAB_PERE <- wtd.table(erfi$AGE_DEP, erfi$FREQ_PERE, weights = erfi$poids12) %>%
  lprop() %>% as.data.frame() %>%
  rename(age = Var1, visite = Var2) %>%
  filter(age != "Ensemble" & visite == "oui") %>% 
  mutate(parent = "pere")

#on rassemble les deux tableaux en un seul
DATA_GRAPH <- rbind(TAB_MERE, TAB_PERE)

#Représentation graphique
ggplot(DATA_GRAPH, aes(age, Freq, color = parent, group = parent)) +
  geom_line() +
  scale_x_discrete(labels = c("Moins de 20 ans", "20-21", "22-23", "24-25", "26-29", "30 ans ou plus")) + #mettre des labels sur l'axe des abscisses
  scale_y_continuous(limits = c(25,65), breaks = c(seq(25,65,5))) + #changer la graduation de l'axe des ordonnées (de 25 à 65, avec un pas de 5)
  scale_color_manual (values = c("#1068c9", "#065535"), labels = c("sa mère", "son père")) + #changer les couleurs des courbes et les labels de la légende
  labs(x = "Age au départ (ans)", y = "En %", title = "Proportion (%) d'enfants voyant au moins une fois par semaine leur père ou leur mère\nselon l'âge au départ du foyer parental", 
       caption = "Champ : femmes et hommes âgés de 30 à 79 ans, dont les deux parents sont encore en vie\nSource : Ined-Insee, ERFI-GGS, 2005", 
       color = "Voit au moins\nune fois par semaine :") +
  theme_classic() +
  theme(plot.title = element_text(face = "bold.italic", 
                                  hjust = 0.5), plot.caption = element_text(face = "italic", hjust = 0), axis.title.y = element_text(hjust = 1), 
        axis.title.x = element_text(hjust = 1))
